package com.swhotels.reservation;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

import java.util.Random;

/*
* La classe <code>HotelAvailability</code> gre les donnes
* d'une disponibilit de la centrale de rservation htelire 
* SW-Htels. 
*
* @version  1.0
*/
public class HotelAvailability {
	
	private final static Random idGenerator = new Random();

	private int id = 0;

	private String hotelRentalCompany = "";
	private String hotelName = "";
	private String hotelLocation = "";
	private float lowerPrice = 0;
	private float higherPrice = 0;

	private int remoteId = 0;
	
	private Writer writer;

	/*
	* Le constructeur de disponibilit de la centrale de
	* rservation htelire.
	*/
	public HotelAvailability() {
		getId();
		try {
			writer = new BufferedWriter(new OutputStreamWriter(System.out, "Cp850"));
		}
		catch(UnsupportedEncodingException e) {
			writer = new BufferedWriter(new OutputStreamWriter(System.out));
		}
	}

	/*
	* Renvoie l'identifiant de la disponibilit.
	*/
	public synchronized int getId() {
		if (id == 0) {
			id = idGenerator.nextInt();
		}
		setRemoteId(id);
		return id;
	}

	/*
	* Renvoie l'identifiant de la disponibilit
	* du partenaire.
	*/
	public int getRemoteId() {
		return this.remoteId;
	}

	/*
	* Affecte l'identifiant de la disponibilit
	* du partenaire.
	*
	* @param		remoteId l'identifiant de la 
	*				disponibilit du partenaire
	*/
	public void setRemoteId(int remoteId) {
		this.remoteId = remoteId;
	}

	/*
	* Affiche dans la log du serveur le statut de la
	* rservation effectue par l'utilisateur.
	*/
	public void status() {

		StringBuffer sb = new StringBuffer();
		sb.append("\n chaine htelire : ");
		sb.append(getHotelRentalCompany());
		sb.append("\n htel : ");
		sb.append(getHotelName());
		sb.append("\n adresse : ");
		sb.append(getHotelLocation());
		sb.append("\n prix minimum : ");
		sb.append(getLowerPrice());
		sb.append("\n prix maximum : ");
		sb.append(getHigherPrice());
		sb.append("\n");
		try {
			writer.write(sb.toString());
			writer.flush();
		}
		catch(IOException e) {
			System.out.println(sb);
		}
	}

	/*
	* Renvoie le nom de la chaine de location htelire.
	*/
	public String getHotelRentalCompany() {
		return hotelRentalCompany;
	}

	/*
	* Affecte le nom de la chaine de location htelire.
	*
	* @param		hotelRentalCompany le nom de la chaine 
	*				de location htelire
	*/
	public void setHotelRentalCompany(String hotelRentalCompany) {
		this.hotelRentalCompany = hotelRentalCompany;
	}

	/*
	* Renvoie le nom de l'htel.
	*/
	public String getHotelName() {
		return hotelName;
	}

	/*
	* Affecte le nom de l'htel.
	*
	* @param		hotelName le nom de l'htel
	*/
	public void setHotelName(String hotelName) {
		this.hotelName = hotelName;
	}

	/*
	* Renvoie la localisation de l'htel.
	*/
	public String getHotelLocation() {
		return hotelLocation;
	}

	/*
	* Affecte la localisation de l'htel.
	*
	* @param		hotelLocation la localisation 
	*				de l'htel
	*/
	public void setHotelLocation(String hotelLocation) {
		this.hotelLocation = hotelLocation;
	}

	/*
	* Renvoie le prix de minimum de rservation.
	*/
	public float getLowerPrice() {
		return lowerPrice;
	}

	/*
	* Affecte le prix de minimum de rservation.
	*
	* @param		lowerPrice le prix minimum
	*/
	public void setLowerPrice(float lowerPrice) {
		this.lowerPrice = lowerPrice;
	}

	/*
	* Renvoie le prix de maximum de rservation.
	*/
	public float getHigherPrice() {
		return higherPrice;
	}

	/*
	* Affecte le prix de maximum de rservation.
	*
	* @param		higherPrice le prix maximum
	*/
	public void setHigherPrice(float higherPrice) {
		this.higherPrice = higherPrice;
	}

	/*
	* Renvoie une reprsentation textuelle de la
	* disponibilit du partenaire. 
	*
	* @return		une reprsentation textuelle de la
	* 				disponibilit.
	*/
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("\n");
		sb.append(getClass().getName());
		sb.append("@");
		sb.append(Integer.toHexString(hashCode()));
		return sb.toString();
	}
}